<?php

defined('BASEPATH') || exit('No direct script access allowed');

class Home extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
    }

    public function index() {
        redirect('home/login');
    }

    public function login() {
        $this->load->view('login/login');
    }

    public function logout() {
        $session_user = $this->session->userdata('cbt_sess_pelaksana');

        if (is_array($session_user)) {
            $akses = $session_user['akses'];
            if ($akses == 'SISWA') {
                $this->db->where('peserta', $session_user['id_user']);
                $this->db->delete('log_user_login');
            }
        }
        $this->session->sess_destroy();
        redirect('home/login', 'refresh');
    }

    public function do_login() {
        $this->load->library('form_validation');

        $this->form_validation->set_rules('txt_username', 'Username', 'required');
        $this->form_validation->set_rules('txt_password', 'Password', 'required|callback_cek_pengguna');

        if ($this->form_validation->run() == FALSE) {
            echo 'Opss..<br/>' . validation_errors();
        } else {
            echo 'OK';
        }
    }

    public function cek_pengguna($password) {
        $this->load->model('msite');
//Field validation succeeded.  Validate against database
        $username = $this->input->post('txt_username');

//query the database
        $result = $this->msite->login($username, $password);
        if (!$result) {
//jika tidak ada cari di guru
            $result = $this->msite->loginSiswa($username, $password);

            if (!$result) {

            } else {
                //cek apakah ybs sedang login?
                $cek_login = $this->db->from('log_user_login')
                    ->where('peserta', $result->id_peserta)
                    ->get()->row();

                if ($cek_login) {
                    //jika sedang login
                    $this->form_validation->set_message('cek_pengguna', 'Username dana Password Pengguna sudah ada yang menggunakan/Sedang digunakan, silahkan gunakan username dan password yang lain');
                    return FALSE;
                } else {
                    $result->id_user = $result->id_peserta;
                    $result->akses   = 'SISWA';
                    $result->avatar  = $result->photo;

                    $log            = array();
                    $log['peserta'] = $result->id_peserta;

                    $this->db->insert('log_user_login', $log);
                }
            }
        }

        if ($result) {
            $sess_array = array(
                'id_user'      => $result->id_user,
                'username'     => $result->username,
                'nama_lengkap' => $result->nama_lengkap,
                'akses'        => $result->akses,
                'avatar'       => $result->avatar,
            );
            $this->session->set_userdata('cbt_sess_pelaksana', $sess_array);

            return TRUE;
        } else {
            $this->form_validation->set_message('cek_pengguna', 'username or password tidak valid.');
            return false;
        }
    }

}
