<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Cetak Analisis Soal</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <style>
        body {
            font-family: Arial, 'Helvetica Neue', Helvetica, sans-serif;
            padding-top: 0px;
            font-size: 14px;
        }

        h1 {
            font-size: 16px;
            padding: 1px;
            text-align: center;
        }

        h3 {
            font-size: 14px;
            padding: 1px;
        }

        .hr {
            border-bottom: 1px solid #000;
            padding-top: 1px;
            padding-bottom: 2px;
        }

        table.gridtable {
            font-size: 14px;
            color: #333333;
            border-width: 1px;
            border-color: #666666;
            border-collapse: collapse;
            width: 100%;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
        }

        table.gridtable th {
            border-width: 1px;
            padding: 4px;
            border-style: solid;
            border-color: #666666;
            background-color: #dedede;
        }

        table.gridtable tr {
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            border-bottom: 1px solid #000;
        }

        table.gridtable td {
            padding: 2px;
        }

        table.gridtable td.total {
            border: 1px solid #000;
            padding: 2px;
            font-weight: bold;
        }

        table.gridtable td.nototal {
            font-size: 14px;
            font-weight: bold;
            border: 0px;
            padding: 2px;
        }

        div.columns {
            column-width: 400px;
            -moz-column-width: 400px;
            -webkit-column-width: 400px;
        }

        div.keeptogether {
            display: inline-block;
            width: 100%;
        }
    </style>
</head>

<body>
    <h1>ANALISIS BOBOT SOAL</h1>
    <h1>MATA PELAJARAN <?php echo $detail->nama_mata_pelajaran; ?></h1>
    <h1>PAKET <?php echo $detail->deskripsi; ?></h1>
    <hr />
    <table class="gridtable">
        <tr>
            <th>NO</th>
            <th>No Induk</th>
            <th>Nama Siswa/Peserta Ujian</th>
            <th>Mata Pelajaran</th>
            <th>Waktu Pelaksanaan</th>
            <th>Status</th>
            <?php
            $total_pertanyaan = array();
            if ($soal) {
                $no = 0;
                foreach ($soal as $s) {
                    $no++;
                    $total_pertanyaan[$no] = 0;
                    echo '<th>Q.' . $no . '</th>';
                }
            }
            ?>
            <th>SKOR</th>
        </tr>
        <?php
        $jumlah_peserta = 0;
        $this->db->select('*');
        $this->db->from('ujian_dilaksanakan');
        $this->db->where('paket_soal', $detail->id_paket_soal);
        $this->db->join('siswa', 'peserta=id_peserta', 'LEFT');

        $query = $this->db->get();

        //echo $this->db->last_query();

        if ($query->num_rows() > 0) {
            $hasil = $query->result();
            $no = 0;
            $total_nilai = 0;

            foreach ($hasil as $h) {
                $jumlah_peserta++;
                $no++;
                $total_nilai += ($h->jumlah_benar / $h->jumlah_soal) * 100;
        ?>
                <tr>
                    <td><?php echo $no; ?></td>
                    <td><?php echo $h->no_induk; ?></td>
                    <td><?php echo $h->nama_lengkap; ?></td>
                    <td><?php echo $detail->nama_mata_pelajaran; ?></td>
                    <td><?php echo date('d/m/Y H:i:s', strtotime($h->mulai_ujian)); ?></td>
                    <td><?php echo $h->status_ujian; ?></td>
                    <?php
                    if ($soal) {
                        $total_skor = 0;
                        $no = 0;
                        foreach ($soal as $s) {
                            $no++;

                            $skor = $this->db->from('soal_ujian')
                                ->where('ujian_yang_dilaksanakan', $h->id_ujian_dilaksanakan)
                                ->where('no_soal', $no)
                                ->get()->row();

                            echo '<td style="text-align:center;">' . ($skor ? $skor->skor_ujian : 0) . '</td>';
                            $total_pertanyaan[$no] += ($skor ? $skor->skor_ujian : 0);
                            $total_skor += ($skor ? $skor->skor_ujian : 0);
                            // $this->db->select('*');
                            // $this->db->from('soal_ujian');
                            // $this->db->where('ujian_yang_dilaksanakan', $h->id_ujian_dilaksanakan);
                            // $this->db->where('pertanyaan', $s->bank_soal);
                            // $this->db->order_by('no_soal');

                            // $query = $this->db->get();

                            // if ($query->num_rows() == 1) {
                            //     $j = $query->row();
                            //     $nilai =  $s->skor_ujian;

                            //     $total_pertanyaan[$no] += $nilai;
                            //     echo '<td>' . $nilai . '</td>';
                            // }
                        }
                    }
                    ?>
                     <td><?php echo $total_skor; ?></td>
                </tr>
                <tr>
                    <th colspan="5">Rata-rata</th>
                    <th><?php echo ($total_nilai / $jumlah_peserta); ?></th>
                    <?php
                    if ($soal) {
                        $jum = $detail->jumlah_soal;
                        $bobot = 100 / $jum;
                        $no = 0;
                        foreach ($soal as $s) {
                            $no++;
                            echo '<th>' . $total_pertanyaan[$no] . '</th>';
                        }
                    }
                    ?>
                    <th></th>
                </tr>
            <?php
            }
        } else {
            ?>
            <tr>
                <td colspan="200">Tidak ada data ujian</td>
            </tr>
        <?php
        }
        ?>
    </table>
</body>

</html>