<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>Cetak Kartu Ujian</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <style>
            body{
                font-family: Arial, 'Helvetica Neue', Helvetica, sans-serif;
                padding-top:0px;
                font-size:12px;
                line-height: 100%;
            }

            h1{
                font-size: 14px;
                padding:1px;
            }

            h3{
                font-size: 12px;
                padding: 1px;
            }

            .hr{
                border-bottom: 1px solid #000;
                padding-top: 1px;
                padding-bottom: 2px;
            }

            table.gridtable {
                font-size:12px;
                color:#333333;
                border-width: 1px;
                border-color: #666666;
                border-collapse: collapse;
                width: 400px;
                border-top: 1px solid #000;
                border-bottom: 1px solid #000;
            }

            table.gridtable th {
                border-width: 1px;
                padding: 4px;
                border-style: solid;
                border-color: #666666;
                background-color: #dedede;
            }

            table.gridtable tr {
                border-left: 1px solid #000;
                border-right: 1px solid #000;
            }

            table.gridtable td {
                padding: 2px;
            }

            table.gridtable td.total {
                border: 1px solid #000;
                padding: 2px;
                font-weight: bold;
            }
            table.gridtable td.nototal {
                font-size: 12px;
                font-weight: bold;
                border: 0px;
                padding: 2px;
            }

            div.columns {
                column-width: 350px;
                -moz-column-width: 350px;
                -webkit-column-width: 350px;
            }
            div.keeptogether {
                display: inline-block;
                width: 100%;
            }
        </style>
    </head>
    <body>
        <div class="columns">
            <?php
            if ($siswa) {
                foreach ($siswa as $v) {
                    ?>
                    <div class="keeptogether">
                        <table class="gridtable">
                            <tr>
                                <th><img src="<?php echo base_url('/assets/uploads') . '/' . $seting->logo; ?>" width="60px"/></th>
                                <th><h1><?php echo $seting->header; ?></h1></th>
                            </tr>
                        </table>
                        <table class="gridtable">
                            <tr>
                                <td width="30%">Nama</td>
                                <td>:</td>
                                <td><?php echo $v->nama_lengkap; ?></td>
                            </tr>
                            <tr>
                                <td>Jenjang Pendidikan</td>
                                <td>:</td>
                                <td><?php echo $v->nama_jenjang_pendidikan; ?></td>
                            </tr>
                            <tr>
                                <td>Kelas</td>
                                <td>:</td>
                                <td><?php echo $v->nama_kelas . ' (Jurusan: ' . $v->nama_jurusan . ')'; ?></td>
                            </tr>
                            <tr>
                                <td>Username</td>
                                <td>:</td>
                                <td><?php echo $v->username; ?></td>
                            </tr>
                            <tr>
                                <td>Password</td>
                                <td>:</td>
                                <td><?php echo $v->password; ?></td>
                            </tr>
                            <tr>
                                <td colspan="2"></td>
                            </tr>
                        </table>
                        <table class="gridtable">
                            <tr>
                                <td width="40%">
                                    Catatan:
                                    <br/>
                                    <?php echo $seting->catatan; ?>
                                </td>
                                <td width="10%">
                                    &nbsp;
                                </td>
                                <td>
                                    <?php echo $seting->kota . ', ' . date('d/m/Y'); ?>
                                    <br/><strong>Kepala Sekolah</strong>
                                    <br/>
                                    <br/>
                                    <br/>
                                    <?php echo $seting->kepala_sekolah; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <?php
                }
            }
            ?>
        </div>

    </body>
</html>