<!--main-container-part-->
<div id="content">
    <!--breadcrumbs-->
    <div id="content-header">
        <div id="breadcrumb"> <a href="<?php echo site_url('admin'); ?>" title="Go to Home" class="tip-bottom"><i class="icon-home"></i> Home</a></div>
    </div>
    <!--End-breadcrumbs-->

    <!--Action boxes-->
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="span6">
                <div class="widget-box">
                    <div class="widget-title"> <span class="icon"> <i class="icon-list"></i> </span>
                        <h5>Live Update</h5>
                    </div>
                    <div class="widget-content">
                        <a href="#" class="btn btn-block btn-danger btn-lg" id="live_patch">Live Update</a>
                    </div>
                </div>
            </div>
            <div class="span6">
                <div class="widget-box">
                    <div class="widget-title"> <span class="icon"> <i class="icon-list"></i> </span>
                        <h5>Info Update</h5>
                    </div>
                    <div class="widget-content">
                        <div id="info_update">Last update: <?= $status_cbt->last_update; ?></div>
                        <h4>History Update</h4>
                        <?php
                        $history_update = $this->db->from('history_update')->order_by('waktu_update', 'desc')->get()->result();
                        if($history_update) {
                            foreach($history_update as $row) {
                                echo '<p>['. $row->waktu_update . '] '. $row->keterangan_update .' - ' . $row->status_update . '</p>';
                            }
                        }
                        ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        const cekStatusBtn = $('#live_patch');
        const infoDiv = $('#info_update');

        function cekStatus() {
            cekStatusBtn.text('Checking...').removeClass('btn-success btn-danger btn-warning').addClass('btn-primary');

            // Ajax request ke backend untuk cek status
            $.ajax({
                type: "GET",
                crossDomain: true,
                dataType: "json",
                url: "<?php echo site_url('admin/cek_update'); ?>",
                success: function(result) {
                    if (result.message !== "") {
                        cekStatusBtn.text(result.message);
                    }

                    if (result.status === "ada") {
                        cekStatusBtn.removeClass("btn-danger btn-warning").addClass("btn-success");
                    } else {
                        cekStatusBtn.removeClass("btn-success btn-warning").addClass("btn-danger");
                    }
                },
                error: function(xhr, status, error) {
                    cekStatusBtn.removeClass("btn-success btn-danger").addClass("btn-warning");
                    cekStatusBtn.text("GAGAL ...");
                }
            });
        }

        // Jalankan pengecekan otomatis saat halaman dimuat
        cekStatus();

        // Variable to track if the update is in progress
        let isUpdating = false;

        cekStatusBtn.on('click', function(e) {
            e.preventDefault(); // Prevent the default action of the button

            // Check if an update is already in progress
            if (isUpdating) {
                return; // Exit if an update is already in progress
            }

            // Set the flag to indicate that an update is in progress
            isUpdating = true;
            cekStatusBtn.prop('disabled', true);
            $.ajax({
                type: "GET",
                crossDomain: true,
                dataType: "json",
                url: "<?php echo site_url('admin/do_update'); ?>",
                success: function(result) {
                    if (result.message !== "") {
                        infoDiv.html(result.message);
                    }

                    if (result.status === "success") {
                        cekStatusBtn.removeClass("btn-danger btn-warning").addClass("btn-success");
                        //reload
                        window.location.reload();
                    } else {
                        cekStatusBtn.removeClass("btn-success btn-warning").addClass("btn-danger");
                    }
                },
                error: function(xhr, status, error) {
                    cekStatusBtn.removeClass("btn-success btn-danger").addClass("btn-warning");
                    infoDiv.html("GAGAL - melakukan update");
                },
                complete: function() {
                    // Re-enable the button and reset the flag
                    cekStatusBtn.prop('disabled', false);
                    isUpdating = false;
                }
            });
        });

        // Warn the user if they try to leave the page while an update is in progress
        window.addEventListener('beforeunload', function(e) {
            if (isUpdating) {
                // Show a confirmation dialog
                const confirmationMessage = "Proses update sedang berlangsung. Apakah Anda yakin ingin meninggalkan halaman ini?";
                e.returnValue = confirmationMessage; // For most browsers
                return confirmationMessage; // For some older browsers
            }
        });
    });
</script>
