<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Halaman Ujian</title>
    <style>
        /* Mengatur gaya untuk memastikan iframe mengisi seluruh halaman */
        html,
        body {
            height: 100%;
            margin: 0;
            padding: 0;
            position: relative;
            /* Untuk posisi elemen melayang */
            overflow: hidden;
            /* Menghilangkan scrollbar pada body */
        }

        iframe {
            width: 100%;
            height: 100%;
            border: none;
            /* Menghilangkan border iframe */
        }

        .button {
            position: absolute;
            bottom: 20px;
            /* Jarak dari bawah */
            left: 50%;
            /* Pusatkan secara horizontal */
            transform: translateX(-50%);
            /* Pindahkan setengah lebar tombol ke kiri */
            background-color: red;
            /* Warna latar belakang merah */
            color: white;
            /* Warna teks putih */
            padding: 10px 20px;
            /* Padding tombol */
            text-decoration: none;
            /* Menghilangkan garis bawah */
            border-radius: 5px;
            /* Sudut membulat */
            font-size: 16px;
            /* Ukuran font */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            /* Bayangan */
            transition: background-color 0.3s;
            /* Transisi warna latar belakang */
        }

        .button:hover {
            background-color: darkred;
            /* Warna saat hover */
        }
    </style>
    <link rel="stylesheet" href="<?= base_url('assets/'); ?>sweetalert.min.css">
    <script src="<?= base_url('assets/'); ?>sweetalert.min.js"></script>

</head>

<body>

    <script>
        // Pastikan $ujian->mulai_ujian adalah UNIX timestamp (dalam detik)
        var startTime = <?= strtotime($ujian->mulai_ujian); ?> * 1000; // convert ke milidetik
        var durasi = <?= $ujian->minimal_waktu_selesai; ?>; // dalam menit

        function checkExamTime(event) {
            console.log(startTime);
            var elapsedTime = (Date.now() - startTime) / 60000; // dalam menit

            if (elapsedTime >= durasi) {
                Swal.fire({
                    title: "Konfirmasi",
                    text: "Anda yakin ingin menyelesaikan ujian ini?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Ya, Selesaikan",
                    cancelButtonText: "Batal",
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = "<?= site_url('ujian/selesaikan_ujian/' . $ujian->id_ujian_dilaksanakan); ?>";
                    }
                });

                event.preventDefault();
                return false;
            } else {
                // Hitung jam selesai
                var endTime = new Date(startTime + (durasi * 60 * 1000));
                var options = {
                    hour: '2-digit',
                    minute: '2-digit',
                    hour12: false
                };
                var formattedEndTime = endTime.toLocaleTimeString('id-ID', options);

                Swal.fire({
                    title: "Informasi",
                    text: "Batas waktu minimal pengerjaan soal adalah " + durasi + " menit.\nAnda dapat mengakhiri ujian pada pukul " + formattedEndTime + ".",
                    icon: "info",
                    confirmButtonText: "OK"
                });

                event.preventDefault();
                return false;
            }
        }
    </script>

    <iframe src="<?= site_url('ujian/do_ujian/' . $idUjian) ?>" title="Iframe Example"></iframe>
    <a href="<?php echo site_url('ujian/selesaikan_ujian/' . $ujian->id_ujian_dilaksanakan); ?>"
        class="button"
        onclick="return checkExamTime(event)">
        <i class="icon icon-warning-sign"></i> Selesaikan Ujian
    </a>

    <?php
    // if ($ujian->blok_durasi_layar > 0) {
    if (false) {
    ?>
        <div id="inactive-overlay" class="inactive-overlay" style="display: none;">
            <div class="inactive-overlay-text">
                Anda tidak boleh berinteraksi dengan TAB lain, atau aplikasi lain saat melakukan ujian.<br><br>
                Menutup blokiran dalam <span id="countdown"><?php echo $ujian->blok_durasi_layar; ?></span> detik.
            </div>
        </div>

        <style>
            /* Gaya untuk overlay ketidakaktifan */
            .inactive-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.9);
                /* Hitam dengan transparansi 90% */
                display: none;
                /* Sembunyikan overlay secara default */
                justify-content: center;
                /* Pusatkan konten secara horizontal */
                align-items: center;
                /* Pusatkan konten secara vertikal */
                z-index: 9997;
                /* Di bawah overlay izin */
            }

            .inactive-overlay-text {
                color: white;
                /* Warna teks */
                font-size: 24px;
                /* Ukuran font */
                text-align: center;
                /* Pusatkan teks */
                margin: 20px;
                /* Jarak sekitar teks */
            }
        </style>

        <script>
            // Variabel untuk melacak ketidakaktifan dan hitungan mundur
            let countdownInterval;
            const INACTIVITY_LIMIT = 10000;
            const COUNTDOWN_LIMIT = <?php echo $ujian->blok_durasi_layar; ?>; // Hitungan mundur dalam detik
            const overlayInactive = document.getElementById('inactive-overlay');
            const countdownElement = document.getElementById('countdown');
            let countdownActive = false; // Indikator jika hitung mundur sedang aktif

            // Fungsi untuk menampilkan overlay
            function showOverlay() {
                overlayInactive.style.display = 'flex';
            }

            // Fungsi untuk menyembunyikan overlay
            function hideOverlay() {
                overlayInactive.style.display = 'none';
                countdownActive = false; // Reset status countdown
            }

            // Reset timer ketidakaktifan
            function resetInactivityTimer() {
                clearTimeout(inactivityTimeout);
                clearInterval(countdownInterval); // Hentikan countdown jika ada
                hideOverlay(); // Pastikan overlay disembunyikan
                inactivityTimeout = setTimeout(showOverlay, INACTIVITY_LIMIT);
            }

            // Fungsi untuk memulai hitungan mundur
            function startCountdown() {
                if (countdownActive) return; // Hindari memulai ulang jika countdown sedang berjalan

                countdownActive = true;
                let countdown = COUNTDOWN_LIMIT; // Atur hitungan awal
                countdownElement.textContent = countdown; // Tampilkan hitungan awal

                countdownInterval = setInterval(() => {
                    countdown--;
                    countdownElement.textContent = countdown; // Perbarui hitungan mundur
                    if (countdown <= 0) {
                        clearInterval(countdownInterval); // Hentikan interval
                        hideOverlay(); // Sembunyikan overlay setelah hitungan selesai
                    }
                }, 1000); // Perbarui setiap detik
            }

            // Dengarkan event aktivitas pengguna
            ['mousemove', 'keydown', 'mousedown', 'touchstart', 'scroll'].forEach(event => {
                document.addEventListener(event, () => {
                    if (overlayInactive.style.display === 'flex' && !countdownActive) {
                        // Jika overlay ditampilkan dan countdown belum aktif
                        startCountdown();
                    } else if (overlayInactive.style.display !== 'flex') {
                        // Reset timer ketidakaktifan jika overlay tidak ditampilkan
                        resetInactivityTimer();
                    }
                });
            });

            // Inisialisasi timer ketidakaktifan
            resetInactivityTimer();
        </script>
    <?php
    }
    ?>

    <script>
        // Cegah klik kanan untuk menonaktifkan akses cepat ke developer tools atau reload
        document.addEventListener('contextmenu', (event) => {
            event.preventDefault();
            alert("Klik kanan telah dinonaktifkan selama ujian.");
        });
    </script>

    <?php if ($ujian->cek_rasio_layar == 'YA') { ?>
        <style>
            .inactive-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.9);
                display: none;
                justify-content: center;
                align-items: center;
                z-index: 9999;
            }

            .inactive-overlay-text {
                color: white;
                font-size: 24px;
                text-align: center;
                margin: 20px;
            }

            #uf_fullscreen-button-rasio,
            #uf_start-fullscreen-button-rasio {
                background-color: #007bff;
                color: white;
                border: none;
                border-radius: 5px;
                cursor: pointer;
            }

            #uf_fullscreen-button-rasio:hover,
            #uf_start-fullscreen-button-rasio:hover {
                background-color: #0056b3;
            }
        </style>

        <div id="uf_start-overlay-rasio" class="inactive-overlay" style="display: none;">
            <div class="inactive-overlay-text">
                Untuk memulai ujian, Anda harus masuk ke mode fullscreen.<br><br>
                <button id="uf_start-fullscreen-button-rasio" style="padding: 10px 20px; font-size: 18px;">
                    Klik di sini untuk masuk ke mode fullscreen
                </button>
            </div>
        </div>

        <div id="uf_inactive-overlay-rasio" class="inactive-overlay" style="display: none;">
            <div class="inactive-overlay-text">
                Anda tidak boleh berpindah aplikasi, meminimize browser, atau keluar dari mode fullscreen saat ujian berlangsung.<br>
                Kembali ke fullscreen dalam <span id="uf_countdown-rasio"><?php echo $ujian->blok_durasi_layar; ?></span> detik atau ujian akan dihentikan.<br><br>
                <button id="uf_fullscreen-button-rasio" style="padding: 10px 20px; font-size: 18px;">Klik di sini untuk kembali ke mode fullscreen</button>
            </div>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const uf_startOverlay = document.getElementById('uf_start-overlay-rasio');
                const uf_inactiveOverlay = document.getElementById('uf_inactive-overlay-rasio');
                const uf_startFullscreenButton = document.getElementById('uf_start-fullscreen-button-rasio');
                const uf_fullscreenButton = document.getElementById('uf_fullscreen-button-rasio');
                const uf_countdownElement = document.getElementById('uf_countdown-rasio');

                let uf_initialCountdown = parseInt(uf_countdownElement.textContent); // Simpan nilai awal countdown
                let uf_intervalId = null; // ID untuk interval countdown

                // Cek fullscreen saat halaman termuat dengan penundaan
                setTimeout(uf_checkFullscreen, 100);

                // Periksa status fullscreen dari sessionStorage
                if (sessionStorage.getItem('isFullscreen') === 'true') {
                    document.documentElement.requestFullscreen().catch(err => {
                        // console.error(`Failed to re-enter fullscreen: ${err.message}`);
                    });
                }

                // Menangani tombol untuk masuk ke fullscreen
                uf_startFullscreenButton.addEventListener('click', function() {
                    document.documentElement.requestFullscreen().then(() => {
                        uf_startOverlay.style.display = 'none';
                        sessionStorage.setItem('isFullscreen', 'true'); // Simpan status fullscreen
                    }).catch(err => {
                        // console.error(`Error attempting to enable full-screen mode: ${err.message} (${err.name})`);
                    });
                });

                // Menangani tombol untuk kembali ke fullscreen
                uf_fullscreenButton.addEventListener('click', function() {
                    document.documentElement.requestFullscreen().then(() => {
                        uf_inactiveOverlay.style.display = 'none';
                        uf_resetCountdown(); // Reset countdown saat fullscreen aktif
                    }).catch(err => {
                        // console.error(`Error attempting to re-enter full-screen mode: ${err.message}`);
                    });
                });

                // Menangani perubahan status fullscreen
                document.addEventListener('fullscreenchange', function() {
                    if (document.fullscreenElement) {
                        uf_inactiveOverlay.style.display = 'none';
                        sessionStorage.setItem('isFullscreen', 'true');
                        uf_resetCountdown(); // Reset countdown saat kembali ke fullscreen
                    } else {
                        uf_inactiveOverlay.style.display = 'flex';
                        uf_startOverlay.style.display = 'none';
                        sessionStorage.setItem('isFullscreen', 'false');
                        uf_startCountdown();
                    }
                });

                // Fungsi untuk memulai countdown
                function uf_startCountdown() {
                    let uf_countdown = parseInt(uf_countdownElement.textContent);
                    uf_intervalId = setInterval(function() {
                        uf_countdown--;
                        uf_countdownElement.textContent = uf_countdown;
                        if (uf_countdown <= 0) {
                            clearInterval(uf_intervalId);
                            alert('Ujian dihentikan karena keluar dari fullscreen.');
                            window.location.href = "/ujian";
                        }
                    }, 1000);
                }

                // Fungsi untuk reset countdown
                function uf_resetCountdown() {
                    clearInterval(uf_intervalId); // Hentikan interval
                    uf_countdownElement.textContent = uf_initialCountdown; // Reset ke nilai awal
                }

                // Fungsi untuk memeriksa fullscreen
                function uf_checkFullscreen() {
                    console.log("Pengecekan Fullscreen: ", document.fullscreenElement);
                    console.log('Ukuran Jendela: ' + window.outerHeight + ' x ' + window.outerWidth);
                    console.log('Ukuran Layar: ' + screen.height + ' x ' + screen.width);

                    if (!document.fullscreenElement &&
                        (window.outerHeight !== screen.height || window.outerWidth !== screen.width)) {
                        uf_startOverlay.style.display = 'flex';
                    } else {
                        uf_startOverlay.style.display = 'none';
                    }
                }
            });
        </script>

    <?php } ?>

    <?php if (isset($error) && $error != ''): ?>
        <script>
            Swal.fire({
                title: "Informasi",
                text: "<?= $error ?>",
                icon: "info",
                confirmButtonText: "OK"
            });
        </script>
    <?php endif; ?>

</body>

</html>
